
# Icon Update

Author mk@synergyxr.com

To add or remove icons, the resources file also has to be updated. To do this, I've created a priconfig.xml file that tells makepri.exe how to interpret the asset files in the folder. This file was initially created using the MSIX builds tools, but as we no longer have that, I've tried to match the config file to what I think the original was (used makepri dump to get some hints).

First delete the original Resources.pri file.

Then you can use makepri new to create a new Resources.pri:

```bash
makepri new /pr . /cf priconfig.xml /of Resources.pri
```

This requires makepri.exe to be in your PATH. The one I used is in:
*ThisRepo*\Tools\ContinuousIntegration\SynergyBuild\_Files\MSIX-Toolkit-master\WindowsSDK\11\10.0.22000.0\x64

The icons use some AlternateForm attributes to decide which icons to use for different things (light/dark mode, high contrast black/white). See more here:
[Tailor your resources for language, scale, high contrast, and other qualifiers](https://learn.microsoft.com/en-us/windows/uwp/app-resources/tailor-resources-lang-scale-contrast)

We store the AlternateForm attributes and values in the filenames. It can also be stored in the folder paths. Currently, all icons are just the same. Optimally we should have different icons for especially the high contrast themes to increase accessability.

Before committing the new .pri file, validate it using:

```bash
makepri dump /if .\Resources.pri /dt detailed
```

Make sure there are no dublicate name+value combos in the Qualifiers section as it will give an error about duplicate assets on MS Store upload. Below is a valid qualifiers block:

```xml
<Qualifiers>
    <Qualifier name="Contrast" value="WHITE" priority="400" scoreAsDefault="0.0" index="1"/>
    <Qualifier name="Scale" value="400" priority="200" scoreAsDefault="0.44" index="2"/>
    <Qualifier name="Contrast" value="BLACK" priority="400" scoreAsDefault="0.0" index="3"/>
    <Qualifier name="AlternateForm" value="UNPLATED" priority="100" scoreAsDefault="0.0" index="4"/>
    <Qualifier name="Scale" value="200" priority="200" scoreAsDefault="0.75" index="5"/>
    <Qualifier name="Scale" value="150" priority="200" scoreAsDefault="0.88" index="6"/>
    <Qualifier name="Scale" value="125" priority="200" scoreAsDefault="0.94" index="7"/>
    <Qualifier name="Scale" value="100" priority="200" scoreAsDefault="1.0" index="8"/>
    <Qualifier name="TargetSize" value="48" priority="300" scoreAsDefault="0.5" index="9"/>
    <Qualifier name="TargetSize" value="32" priority="300" scoreAsDefault="0.5" index="10"/>
    <Qualifier name="TargetSize" value="256" priority="300" scoreAsDefault="1.0" index="11"/>
    <Qualifier name="TargetSize" value="24" priority="300" scoreAsDefault="0.5" index="12"/>
    <Qualifier name="TargetSize" value="16" priority="300" scoreAsDefault="0.5" index="13"/>
</Qualifiers>
```
